import asyncio
import logging
from aiogram import Bot, Dispatcher
from aiogram.enums import ParseMode
from aiogram.client.default import DefaultBotProperties
from config import BOT_TOKEN
from handlers import download, admin
from middlewares.throttling import ThrottlingMiddleware
from utils.database import init_db

logging.basicConfig(level=logging.INFO)

async def main():
    await init_db()
    bot = Bot(
        token=BOT_TOKEN,
        default=DefaultBotProperties(parse_mode=ParseMode.HTML)
    )
    dp = Dispatcher()
    dp.message.middleware(ThrottlingMiddleware(rate_limit=3.0))
    dp.include_router(download.router)
    dp.include_router(admin.router)
    print("البوت شغال!")
    await dp.start_polling(bot)

if __name__ == "__main__":
    asyncio.run(main())
