from aiogram.types import InlineKeyboardMarkup
from aiogram.utils.keyboard import InlineKeyboardBuilder

def quality_keyboard(url: str) -> InlineKeyboardMarkup:
    builder = InlineKeyboardBuilder()
    qualities = [
        ("🎬 جودة 4K",      f"dl:2160:{url}"),
        ("📹 جودة 1080p",   f"dl:1080:{url}"),
        ("📺 جودة 720p",    f"dl:720:{url}"),
        ("📱 جودة 480p",    f"dl:480:{url}"),
        ("💾 جودة 360p",    f"dl:360:{url}"),
        ("🎵 صوت MP3 فقط",  f"dl:audio:{url}"),
    ]
    for text, callback in qualities:
        builder.button(text=text, callback_data=callback[:64])
    builder.adjust(2)
    return builder.as_markup()

def cancel_keyboard() -> InlineKeyboardMarkup:
    builder = InlineKeyboardBuilder()
    builder.button(text="❌ إلغاء التنزيل", callback_data="cancel")
    return builder.as_markup()
